#include "..\..\DLL\d_iNES.h"
#include "..\..\Hardware\h_Latch.h"

namespace {
void sync (void) {
	if (Latch::data &0x08) {
		if (Latch::data &0x01) {
			EMU->SetPRG_ROM16(0x8, Latch::data);
			EMU->SetPRG_ROM16(0xC, Latch::data);
		} else
			EMU->SetPRG_ROM32(0x8, Latch::data >>1);
		if (Latch::data &0x10)
			EMU->Mirror_H();
		else
			EMU->Mirror_V();
	} else {
		EMU->SetPRG_ROM16(0x8, Latch::data);
		EMU->SetPRG_ROM16(0xC, Latch::data | 7);
		iNES_SetMirroring();
	}
	iNES_SetCHR_Auto8(0x0, 0);
}

void MAPINT writeLatch (int bank, int addr, int val) {
	if (~Latch::data &0x20) Latch::write(bank, addr, val);
}

BOOL MAPINT load (void) {
	Latch::load(sync, NULL);
	return TRUE;
}

void MAPINT reset (RESET_TYPE) {
	Latch::reset(RESET_HARD);
	Latch::data = 0x08;
	sync();
	for (int bank = 0x8; bank <= 0xF; bank++) EMU->SetCPUWriteHandler(bank, writeLatch);
}

uint16_t mapperNum = 277;
} // namespace


MapperInfo MapperInfo_277 = {
	&mapperNum,
	_T("09-078"),
	COMPAT_FULL,
	load,
	reset,
	NULL,
	NULL,
	NULL,
	Latch::saveLoad_D,
	NULL,
	NULL
};